IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_PG_CRED_PROC_PENDENCIA]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_PG_CRED_PROC_PENDENCIA];
GO

GO
--EXEC P_PG_CRED_PROC_PENDENCIA 1, 2019,01
CREATE PROCEDURE P_PG_CRED_PROC_PENDENCIA @CD_EMP INT, @ANO INT=0, @MES INT=0 
WITH ENCRYPTION
AS
    SET NOCOUNT ON;
    DECLARE @CD_FILIAL INT
	DECLARE @CD_PG_CRED INT
	BEGIN TRY
	   PRINT 'Ano.: ' + CONVERT(VARCHAR(5), @ANO) + ' Mes.: ' + CONVERT(VARCHAR(5), @MES) +  ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
	   DECLARE CPgCredPend CURSOR FAST_FORWARD FOR
		SELECT	
			CD_FILIAL,
			CD_PG_CRED
		FROM
			PG_CRED
		WHERE
			CD_EMP=@CD_EMP
			AND STS_DP <>3
			AND YEAR(DT_VENCTO)=@ANO
			AND MONTH(DT_VENCTO)=@MES

	   OPEN CPgCredPend;
	   FETCH NEXT FROM CPgCredPend INTO @CD_FILIAL,@CD_PG_CRED;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 PRINT 'Filial ' + CONVERT(VARCHAR(5), @CD_FILIAL) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
			 DELETE FROM PG_CRED_PROC_PENDENCIA WHERE CD_EMP=@CD_EMP AND CD_FILIAL=@CD_FILIAL AND CD_PG_CRED=@CD_PG_CRED

			INSERT INTO PG_CRED_PROC_PENDENCIA
			(CD_EMP,
			CD_FILIAL,
			CD_PG_CRED,
			DT_CAD,
			STS_DP)
			SELECT	
				CD_EMP,
				CD_FILIAL,
				CD_PG_CRED,
				GETDATE(),
				STS_DP
			FROM
				PG_CRED
			WHERE
				 CD_EMP=@CD_EMP
				 AND CD_FILIAL = @CD_FILIAL
				 AND CD_PG_CRED = @CD_PG_CRED
		
		FETCH NEXT FROM CPgCredPend INTO @CD_FILIAL,@CD_PG_CRED;
	 		
	   END ;

	   CLOSE CPgCredPend ;
	   DEALLOCATE CPgCredPend ;

	END TRY
    BEGIN CATCH

		CLOSE CPgCredPend;
		DEALLOCATE CPgCredPend;
		DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
		DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
		DECLARE @ErrorState INT = ERROR_STATE();

		INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
			SELECT
				ERROR_NUMBER()	  AS numero
				,@ErrorSeverity	  AS severidade
				,@ErrorState		  AS estado
				,'P_PG_CRED_PROC_PENDENCIA'	  AS rotina
				,ERROR_LINE()		  AS linha
				,@ErrorMessage	  AS mensagem
				,GETDATE()		  AS dtErro ;

	    RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

    END CATCH;